<?php

namespace Drupal\ssid;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages the Scope plugins.
 */
class ScopePluginManager extends DefaultPluginManager implements ScopePluginManagerInterface {

  /**
   * Class constructor.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/ssid/Scope',
      $namespaces,
      $module_handler,
      'Drupal\ssid\Plugin\ScopeInterface',
      'Drupal\ssid\Annotation\Scope'
    );
    $this->setCacheBackend($cache_backend, 'ssid_scope_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function processDefinition(&$definition, $plugin_id) {
    parent::processDefinition($definition, $plugin_id);
    foreach (['id', 'label'] as $required_property) {
      if (empty($definition[$required_property])) {
        throw new PluginException(sprintf('The Scope plugin %s must define the %s property.', $plugin_id, $required_property));
      }
    }
  }

}
