<?php

namespace Drupal\ssid\Service;

use Drupal\Core\Entity\EntityInterface;

/**
 * The Serial Handler interface interface.
 */
interface SerialHandlerInterface {

  /**
   * Get plugin definition names. Useful for select lists.
   */
  public function getScopeDefinitionNames() : array;

  /**
   * Generates a new serial for a given entity and field.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity being processed.
   * @param string $field_name
   *   The field machine name (of type "scope_serial").
   *
   * @return array
   *   The generated serial information.
   *
   * @throws \RuntimeException
   *   If unable to acquire a lock or commit the transaction.
   */
  public function generateSerial(EntityInterface $entity, string $field_name) : array;

}
