# SSO Bouncer

This module extends [OpenID Connect](https://www.drupal.org/project/openid_connect)] functionality to check if a Keycloak SSO account login has at least one group as defined in OpenID Connects role mapping.
## Requirements

- Drupal >11
- Existend [Keycloak](https://www.keycloak.org/) SSO Client
- Drupal [OpenID Connect](https://www.drupal.org/project/openid_connect) with defined role mappings at `/admin/config/people/openid-connect/settings`

## Installation

1. Install with composer.
```bash
composer require drupal/sso_bouncer
```
2. Enable the module through the Drupal admin interface or using Drush:
```bash
drush en sso_bouncer
```
## Configuration

After installation, you can configure the module by navigating to:
`Administration > Configuration > People > SSO Bouncer Settings` or `/admin/config/people/sso-bouncer`

### Settings

- **Enabled**: If SSO Bouncer is enabled or not.
- **Client ID**: Set the client id of which the role mappings for login check come from.

## Usage

The module automatically validates user authentication by checking if the user has valid Keycloak groups for the Drupal instance. If the user's group is not authorized for the current instance, access is denied.

### Drush Commands
The module provides several Drush commands for managing SSO Bouncer configuration:

#### Enable SSO Bouncer
```bash
drush sso_bouncer:enable [CLIENT_ID]
drush sso_bouncer:disable
drush sso_bouncer:status
```

## License

This module is licensed under the GNU General Public License version 3.
