<?php

namespace Drupal\sso_bouncer\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for SSO Bouncer settings.
 */
class SsoBouncerSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['sso_bouncer.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'sso_bouncer_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('sso_bouncer.settings');

    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enabled'),
      '#description' => $this->t('Enable or disable SSO Bouncer.'),
      '#default_value' => $config->get('enabled') ?? FALSE,
    ];

    $form['clientId'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Client ID'),
      '#description' => $this->t('Client ID of the Keycloak SSO Client.'),
      '#default_value' => $config->get('clientId') ?? '',
      '#required' => FALSE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    if ($form_state->getValue('enabled') && empty($form_state->getValue('clientId'))) {
      $form_state->setErrorByName('clientId', $this->t('Client ID is required if SSO Bouncer is enabled.'));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('sso_bouncer.settings')
      ->set('enabled', $form_state->getValue('enabled'))
      ->set('clientId', $form_state->getValue('clientId'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
