// document.addEventListener('DOMContentLoaded', function () {
//   const thumbs = new Swiper('.thumb-swiper', {
//     spaceBetween: 10,
//     slidesPerView: 4,
//     watchSlidesProgress: true,
//     breakpoints: {
//       768: {
//         slidesPerView: 5,
//       }
//     }
//   });

//   const main = new Swiper('.main-swiper', {
//     spaceBetween: 10,
//     navigation: {
//       nextEl: '.swiper-button-next',
//       prevEl: '.swiper-button-prev',
//     },
//     thumbs: {
//       swiper: thumbs,
//     }
//   });
// });
(function ($, Drupal) {
  Drupal.behaviors.bootstrapCarouselRefresh = {
    attach: function (context, settings) {
      // Monitorea el contenedor del producto donde Drupal reemplaza contenido
      const observerTarget = $('.product-image', context).once('carousel-observer');

      if (!observerTarget.length) return;

      const observer = new MutationObserver(function (mutationsList, observer) {
        mutationsList.forEach(function (mutation) {
          if (mutation.type === 'childList') {
            const $carousel = $('.carousel', mutation.target);

            if ($carousel.length) {
              // Reinicia el carrusel (Bootstrap 5)
              $carousel.carousel('dispose');
              $carousel.carousel();

              // Marca primer slide como activo
              $carousel.find('.carousel-item').removeClass('active');
              $carousel.find('.carousel-item').first().addClass('active');

              // Indicadores también
              $carousel.find('.carousel-indicators button').removeClass('active').removeAttr('aria-current');
              $carousel.find('.carousel-indicators button').first().addClass('active').attr('aria-current', 'true');
            }
          }
        });
      });

      observerTarget.each(function () {
        observer.observe(this, {
          childList: true,
          subtree: true,
        });
      });
    }
  };
})(jQuery, Drupal);
