# Guía de Imágenes Responsive para Formularios de Usuario

## Cómo usar imágenes responsive en los templates

### Estructura HTML recomendada:

```html
<img srcset="imagen-mobile-420x200.jpg 420w,
             imagen-tablet-500x400.jpg 768w,
             imagen-desktop-500x600.jpg 1024w"
     sizes="(max-width: 767.98px) 420px,
            (max-width: 1023px) 500px,
            500px"
     src="imagen-desktop-500x600.jpg"
     alt="Descripción de la imagen"
     class="login-image">
```

### Dimensiones recomendadas:

- **Móvil (hasta 767px):** 420x200px - Imagen horizontal, se muestra arriba del formulario
- **Tablet (768px-1023px):** 500x400px - Imagen cuadrada/rectangular
- **Desktop (1024px+):** 500x600px - Imagen vertical para la columna lateral

### Variables disponibles:

- `$auth-mobile-image-height: 200px` - Altura de imagen en móvil
- `$auth-desktop-min-height: 550px` - Altura mínima en desktop

### Mixin disponible:

```scss
@include auth-responsive-image; // Aplica estilos responsive automáticamente
```

### Comportamiento:

- **Móvil:** Imagen aparece arriba del formulario con altura fija de 200px
- **Desktop:** Imagen aparece al lado del formulario ocupando toda la altura
- **object-fit: cover** asegura que la imagen siempre mantenga sus proporciones
- **object-position** optimizado para cada breakpoint
