<?php

namespace Drupal\starrating\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Field\FieldItemListInterface;

/**
 * Plugin implementation of the 'starrating' formatter.
 *
 * @FieldFormatter(
 *   id = "starrating_value",
 *   module = "starrating",
 *   label = @Translation("Star rating value"),
 *   field_types = {
 *     "starrating"
 *   }
 * )
 */
class StarRatingValueFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    foreach ($items as $delta => $item) {
      $output = '<div class="starrating">' . $item->value . '</div>';
      $elements[$delta] = ['#markup' => $output];
    }
    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {

    $summary = [];
    $field_settings = $this->getFieldSettings();
    $max = $field_settings['max_value'];
    $output = '<div class="starrating">' . $max . '</div>';
    $elements = [];
    $elements['#markup'] = $output;
    $summary[] = $elements;

    return $summary;
  }

}
