<?php

namespace Drupal\state_machine_automated_transition\Automator;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowTransition;
use Drupal\state_machine_automated_transition\TransitionAutomatorInterface;
use Drupal\state_machine_automated_transition\TransitionAutomatorResult;

/**
 * Apply transition automatically for an allowed list of transitions.
 *
 * Provides an implementation of the AutomatorInterface for managing automated
 * transitions based on configuration settings.
 */
class ConfigTransitionAutomator implements TransitionAutomatorInterface {

  /**
   * {@inheritdoc}
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function applies(
    WorkflowTransition $transition,
    WorkflowInterface $workflow,
    EntityInterface $entity,
  ): TransitionAutomatorResult {
    $allow_list = $this->configFactory->get('state_machine_automated_transition.settings')->get('allow_list');
    if (!empty($allow_list[$workflow->getGroup()][$workflow->getId()][$transition->getId()])) {
      return TransitionAutomatorResult::allowed();
    }
    return TransitionAutomatorResult::neutral();
  }

}
