<?php

declare(strict_types=1);

namespace Drupal\state_machine_automated_transition\Hook;

use Drupal\Core\Entity\EntityFieldManager;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\state_machine_automated_transition\TransitionAutomatorOrchestrator;
use Drupal\state_machine_automated_transition\TransitionAutomatorManager;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

/**
 * Hook implementations for the node module.
 */
class EntityUpdate {

  public function __construct(
    #[Autowire(service: 'state_machine_automated_transition.orchestrator')]
    private readonly TransitionAutomatorOrchestrator $automatedTransitionOrchestrator,
    #[Autowire(service: 'entity_field.manager')]
    private readonly EntityFieldManager $entityFieldManager,
    private readonly TransitionAutomatorManager $automatorManager,
  ) {
  }

  /**
   * Implements hook_entity_update().
   *
   * Applies consecutive transition at the end of the current transition.
   *
   * @phpstan-ignore-next-line
   */
  #[Hook('entity_update')]
  public function entityUpdate(EntityInterface $entity) {
    // Find field.
    $fields = $this->entityFieldManager->getFieldMapByFieldType('state');
    $fields = $fields[$entity->getEntityTypeId()] ?? [];
    foreach ($fields as $field_name => $field) {
      if (!$entity->hasField($field_name)) {
        continue;
      }
      // @todo If value didn't change, skip.
      if (FALSE) {
        continue;
      }
      /** @var \Drupal\state_machine\Plugin\Field\FieldType\StateItemInterface $state */
      $state = $entity->get($field_name)->first();
      $transitions = $state->getTransitions();
      $workflow = $state->getWorkflow();

      // Find the first allowed transition.
      foreach ($transitions as $transition) {
        if ($this->automatorManager->applies($transition, $workflow, $entity)->isAllowed()) {
          $this->automatedTransitionOrchestrator->addTransition($entity, $field_name, $transition);
          return;
        }
      }
    }
  }

}
