<?php

namespace Drupal\state_machine_automated_transition;

use Drupal\Core\Entity\EntityInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowTransition;
use Symfony\Component\DependencyInjection\Attribute\AsTaggedItem;

/**
 * Defines the interface for automators.
 *
 * Allows for custom logic controlling if the transition can be automatically
 * triggered.
 *
 * Transition can be applied only if there's at least one Automator allowing
 * it and no transitions
 */
#[AsTaggedItem('state_machine_automated_transition.transition_automator')]
interface TransitionAutomatorInterface {

  /**
   * Checks whether the transition is allowed to be executed automatically.
   *
   * @param \Drupal\state_machine\Plugin\Workflow\WorkflowTransition $transition
   *   The transition.
   * @param \Drupal\state_machine\Plugin\Workflow\WorkflowInterface $workflow
   *   The workflow.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The parent entity.
   *
   * @return \Drupal\state_machine_automated_transition\TransitionAutomatorResult
   *   The value object representing whether automated transition is allowed.
   */
  public function applies(WorkflowTransition $transition, WorkflowInterface $workflow, EntityInterface $entity) : TransitionAutomatorResult;

}
