<?php

namespace Drupal\state_machine_automated_transition_test\Automator;

use Drupal\Core\Entity\EntityInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowInterface;
use Drupal\state_machine\Plugin\Workflow\WorkflowTransition;
use Drupal\state_machine_automated_transition\TransitionAutomatorInterface;
use Drupal\state_machine_automated_transition\TransitionAutomatorResult;

/**
 * Test implementation of the automator.
 *
 * Automated transitions are disallowed if entity label starts with DISALLOWED.
 */
class TestTransitionAutomator implements TransitionAutomatorInterface {

  /**
   * {@inheritdoc}
   */
  public function applies(
    WorkflowTransition $transition,
    WorkflowInterface $workflow,
    EntityInterface $entity,
  ): TransitionAutomatorResult {
    if (str_starts_with($entity->label(), 'DISALLOWED')) {
      return TransitionAutomatorResult::forbidden('DISALLOWED');
    }
    return TransitionAutomatorResult::allowed();
  }

}
