<?php

declare(strict_types=1);

namespace Drupal\Tests\state_machine_automated_transition\Kernel;

use Drupal\entity_test\Entity\EntityTestWithBundle;
use Drupal\KernelTests\Core\Entity\EntityKernelTestBase;
use Drupal\Tests\EntityTrait;

/**
 * Test attribute-based and legacy hooks.
 *
 * @coversDefaultClass \Drupal\state_machine_automated_transition\Hook\EntityUpdate
 * @group state_machine_automated_transition
 */
final class HookTest extends EntityKernelTestBase {

  use EntityTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'entity_test',
    'field',
    'user',
    'state_machine',
    'state_machine_test',
    'state_machine_automated_transition',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('entity_test_with_bundle');
    $this->installConfig(['state_machine_test']);

    $this->config('state_machine_automated_transition.settings')->set('allow_list.entity_test_with_bundle.default', [
      'fulfill' => 'fulfill',
    ])->save();
  }

  /**
   * Test callback.
   */
  public function testTransitionHook(): void {
    $entity = EntityTestWithBundle::create([
      'type' => 'first',
      'name' => 'Test entity',
      'field_state' => $initial_state = 'new',
    ]);
    $entity->save();

    $this->assertEquals($initial_state, $entity->get('field_state')->value);
    $entity->get('field_state')->first()->applyTransitionById('create');
    $this->assertEquals('fulfillment', $entity->get('field_state')->value);
    $entity->save();
    \Drupal::service('state_machine_automated_transition.orchestrator')->destruct();
    $entity = $this->reloadEntity($entity);
    $this->assertEquals('completed', $entity->get('field_state')->value);
  }

}
