<?php

declare(strict_types=1);

namespace Drupal\Tests\state_machine_automated_transition\Kernel;

use Drupal\entity_test\Entity\EntityTestWithBundle;
use Drupal\KernelTests\Core\Entity\EntityKernelTestBase;
use Drupal\state_machine_automated_transition\TransitionAutomatorManager;
use Drupal\state_machine_automated_transition\TransitionAutomatorResult;
use Drupal\Tests\EntityTrait;

/**
 * Tests if the manager correctly collects statuses.
 *
 * @coversDefaultClass \Drupal\state_machine_automated_transition\TransitionAutomatorManager
 * @group state_machine_automated_transition
 */
final class TransitionAutomatorManagerTest extends EntityKernelTestBase {

  use EntityTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'entity_test',
    'field',
    'user',
    'state_machine',
    'state_machine_test',
    'state_machine_automated_transition',
    'state_machine_automated_transition_test',
  ];

  /**
   * The manager to be tested.
   *
   * @var \Drupal\state_machine_automated_transition\TransitionAutomatorManager
   */
  protected TransitionAutomatorManager $manager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('entity_test_with_bundle');
    $this->installConfig(['state_machine_test']);

    $this->config('state_machine_automated_transition.settings')->set('allow_list.entity_test_with_bundle.default', [
      'fulfill' => 'fulfill',
    ])->save();

    $this->manager = $this->container->get(TransitionAutomatorManager::class);
  }

  /**
   * Test callback.
   */
  public function testManager(): void {
    $entity = EntityTestWithBundle::create([
      'type' => 'first',
      'name' => 'Test entity',
      'field_state' => $initial_state = 'new',
    ]);
    $entity->save();
    /** @var \Drupal\state_machine\Plugin\Field\FieldType\StateItem $field */
    $field = $entity->get('field_state')->first();
    $field->getTransitions()['create'];
    $result = $this->manager->applies($field->getTransitions()['create'], $field->getWorkflow(), $entity);

    // Test if automated transition is forbidden.
    $this->assertEquals(TransitionAutomatorResult::forbidden('There are no automators allowing this transition.'), $result);

    $entity->get('field_state')->first()->applyTransitionById('create');
    $entity->save();
    $entity = $this->reloadEntity($entity);

    // Test if automated transition is allowed.
    $result = $this->manager->applies($field->getTransitions()['fulfill'], $field->getWorkflow(), $entity);
    $this->assertEquals(TransitionAutomatorResult::allowed(), $result);
  }

}
