<?php

declare(strict_types=1);

namespace Drupal\Tests\state_machine_automated_transition\Kernel;

use Drupal\entity_test\Entity\EntityTestWithBundle;
use Drupal\KernelTests\Core\Entity\EntityKernelTestBase;
use Drupal\state_machine_automated_transition\TransitionAutomatorOrchestrator;
use Drupal\Tests\EntityTrait;

/**
 * Tests if the orchestrator correctly executes transitions.
 *
 * @coversDefaultClass \Drupal\state_machine_automated_transition\TransitionAutomatorOrchestrator
 * @group state_machine_automated_transition
 */
final class TransitionAutomatorOrchestratorTest extends EntityKernelTestBase {

  use EntityTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'entity_test',
    'field',
    'user',
    'state_machine',
    'state_machine_test',
    'state_machine_automated_transition',
  ];

  /**
   * The orchestrator to be tested.
   *
   * @var \Drupal\state_machine_automated_transition\TransitionAutomatorOrchestrator
   */
  protected TransitionAutomatorOrchestrator $orchestrator;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('entity_test_with_bundle');
    $this->installConfig(['state_machine_test']);

    $this->config('state_machine_automated_transition.settings')->set('allow_list.entity_test_with_bundle.default', [
      'fulfill' => 'fulfill',
    ])->save();

    $this->orchestrator = $this->container->get('state_machine_automated_transition.orchestrator');
  }

  /**
   * Test callback.
   */
  public function testDestruct(): void {
    $entity_first = EntityTestWithBundle::create([
      'type' => 'first',
      'name' => 'Test entity 1',
      'field_state' => 'new',
    ]);
    $entity_first->save();
    $entity_first->get('field_state')->first()->applyTransitionById('create');
    $entity_first->save();

    $entity_second = EntityTestWithBundle::create([
      'type' => 'first',
      'name' => 'Test entity 2',
      'field_state' => 'new',
    ]);
    $entity_second->save();
    $entity_second->get('field_state')->first()->applyTransitionById('create');
    $entity_second->save();

    // Execute queued transitions.
    $this->orchestrator->destruct();

    // Reload entities.
    $entity_first = $this->reloadEntity($entity_first);
    $entity_second = $this->reloadEntity($entity_second);
    /** @var \Drupal\state_machine\Plugin\Field\FieldType\StateItem $field */
    $field = $entity_first->get('field_state')->first();
    $this->assertEquals('completed', $field->getId());
    $field = $entity_second->get('field_state')->first();
    $this->assertEquals('completed', $field->getId());
  }

}
