# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Module Overview

Static Content Browser is a Drupal module that provides a file management interface for the Static Content Type module's directories. It allows content creators to browse, upload, edit, and manage files without SFTP access.

## Development Standards

- Follow Drupal coding standards (comments begin with capital letters and end with periods, etc.)
- This module targets Drupal 10, 11, and 12 (see `static_content_browser.info.yml`)
- Depends on `drupal:file` core module
- Work on versions one at a time - test and commit before moving to the next

## Architecture

### Core Components

**Controllers** (`src/Controller/`)
- `StaticContentBrowserController.php` - Main browser pages: top-level directory view, subdirectory browser, file editor
- `StaticContentBrowserAjaxController.php` - AJAX operations: upload, create, delete, rename, move, download_zip

**Services** (`src/Service/`)
- `StaticContentBrowserService.php` - Core file operations, path validation, directory precedence logic
- `StaticContentBrowserTokenService.php` - CSRF token generation for AJAX requests

**Forms** (`src/Form/`)
- `FileEditorForm.php` - WYSIWYG text file editor
- `StaticContentBrowserSettingsForm.php` - Module configuration

### Key Concepts

**Six Content Directory Types** (stored in `/sites/default/files/`):
- `static-content-nodes`, `static-content-blocks`, `static-content-paragraphs`
- `static-content-sdc`, `static-content-twig`, `static-content-pages`

**Directory Precedence** - Within a content directory, these subdirectories have priority order for serving index.html:
1. dist, 2. build, 3. raw, 4. proxied, 5. hardened, 6. src

### Routes

- `/admin/content/static-content-browser` - Top level browser
- `/admin/content/static-content-browser/{directory_type}/{path}` - Subdirectory browser
- `/admin/content/static-content-browser/edit/{directory_type}?file_path=...` - File editor
- `/admin/content/static-content-browser/ajax` - AJAX endpoint
- `/admin/config/content/static-content-browser` - Settings

### Templates

- `static-content-browser-top-level.html.twig` - Six folder icons view
- `static-content-browser-directory.html.twig` - File/directory listing with actions

## Testing URLs

Test nested directory navigation at these depths:
```
/admin/content/static-content-browser/static-content-nodes/27
/admin/content/static-content-browser/static-content-nodes/27/277
/admin/content/static-content-browser/static-content-nodes/27/277/2777
... and deeper
```

---

## Version Roadmap

Versions are tagged as ai-ref-1, ai-ref-2, etc. After 1.0.0, semantic versioning for Drupal.org.

### ai-ref-1 (Initial)
**Working:** View index.html button active, routing to first level
**Issues:** Create file/directory links broken, action menus broken, deep routing 404s

### ai-ref-2
**Fixed:** Create file/directory links, action menus mostly work
**Issues:** Deep routing still 404s, View index.html button no longer activates

### ai-ref-2.5 (Evaluation branch)
Contains Controller changes from a parallel development effort. Evaluate if these changes (CSRF token handling, index_html_path calculation) should be merged.

### ai-ref-3 (Next: Deep Routing Fix)
**Issue:** URLs like `/admin/content/static-content-browser/static-content-nodes/27/277` give 404.

**Solution:** Drupal's routing cannot handle arbitrary path depth with `{path}` parameter. Requires multiple explicit routes (browser0 through browser7) with level parameters:

```yaml
static_content_browser.browser2:
  path: '/admin/content/static-content-browser/{level0}/{level1}'
  defaults:
    _controller: '...::browser2'
```

With corresponding controller methods that reconstruct the path from levels.

### ai-ref-4
**Issue:** View index.html button not highlighting (worked in ai-ref-1, broke after ai-ref-2)

### ai-ref-5
**Issue:** Download Zip action link does nothing

### ai-ref-6
**Fixed:**
- Breadcrumbs show "Static Content Browser" repeatedly instead of subdirectory names

### ai-ref-7 (Current main branch)
**Fixed:**
- index.html files hidden from directory listing
- New File button doesn't refresh page to show new file
- Action dropdown menus clipped/truncated on table rows

**Issue 1:** When viewing a subdirectory containing only an index.html file, the directory appeared empty with "This directory is empty" message. The "View index.html" button worked, but the file wasn't visible in the listing, preventing users from editing it.

**Solution:** Removed filter in `StaticContentBrowserService::getDirectoryListing()` that hid index.html files unless in a precedence directory or root. Now index.html is always visible in listings while the "View index.html" button continues to use precedence rules.

**Issue 2:** Creating a new file would not show it in the listing until manual page refresh, even though the file was created successfully.

**Solution:** Fixed deprecated `Drupal::url()` call in `StaticContentBrowserAjaxController::handleCreateFile()` (not compatible with Drupal 10+). Changed to `Url::fromRoute()->toString()`. Also improved reload logic using sessionStorage to ensure page reloads before opening editor.

**Issue 3:** Action dropdown menus on file rows were being clipped/truncated, showing only partial menu items on rows below the first.

**Solution:** Removed `overflow: hidden` from `.scb-browser-table` in CSS that was causing dropdown menus to be clipped by the table container.

## Reference

See FEATURES.md for detailed feature documentation.
