Static Content Browser (static_content_browser) Module
======================================================

The Static Content Browser module is a helper module we are developing for use with the Drupal Static Content Type module.

## Static Content Type Module
https://www.drupal.org/project/static_content_type
Makes standard static content located in the drupal file system available in Drupal as
Nodes, Blocks, and Paragraphs.

The content files are organized into sub directories stored in the Drupal file space.
The 6 Possible Top Level Directories in the file space where they are stored.

* /admin/content/static-content-browser/static-content-nodes
* /admin/content/static-content-browser/static-content-blocks
* /admin/content/static-content-browser/static-content-paragraphs
* /admin/content/static-content-browser/static-content-sdc
* /admin/content/static-content-browser/static-content-twig
* /admin/content/static-content-browser/static-content-pages

Inside these Directories are sub directories which are named with the numeric entity id or some unique alphanumeric id
that contains the index.html that will display for that entity.

nodes, blocks and paragraphs have numeric names they are node, block or paragraph entity ids.
* /static-content-nodes/123
* /static-content-blocks/456
* /static-content-paragraphs/789

sdc, twig and pages have alphanumeric ids.
* /static-content-sdc/abc1
* /static-content-twig/def1
* /static-content-pages/ghi1

Inside of a Content Directory the index.html file
might be located right in the root of the Content Directory.
or in one of these special sub directories of the Content Directory.

1. dist
2. build
3. raw
4. proxied
5. hardened
6. src

Generally only one of these sub directories of the Content Directory will have files in it.
But they could. Only the Content Directory or one of the 6 sub directories of Content Directory 
will be actually used and served by the Static Content Type module.

Any sub directories at any level inside a Content Directory with names other than those 6
are for assets like images, downloads, css, js etc. and would not have an index.html file in them.


## Static Content Browser
The Static Content Browser module offers Content Creators a way to organize, upload, create and edit files in 
one of the 6 special directories for nodes, blocks, paragraphs etc. in the Drupal file space.

A standard FTP or SFTP application could be used for the same purpose as this module.
Which isolates Content Creators from SFTP details like credentials or ssh keys etc.
It offers an easily comprehendable and usable browser interface for managing the files in only these 6 special directories.
Users are offered A drag and Drop interface for uploading files they create locally with applications on their desktop.
A WYSIWYG editor is provided for editing text files with a browser interface.

The interface provided is three types of pages Top Level Navigation, Subdirectory Management and Navigation and WYSIWYG Editor.

### A main home page - Top Level Navigation
/admin/content/static-content-browser
For displaying 6 Folder icons linking to the 6 Possible Top Level Directories in the Drupal file space with links to the directories displayed in a File Browser Page.


* /admin/content/static-content-browser/static-content-nodes
* /admin/content/static-content-browser/static-content-blocks
* /admin/content/static-content-browser/static-content-paragraphs
* /admin/content/static-content-browser/static-content-sdc
* /admin/content/static-content-browser/static-content-twig
* /admin/content/static-content-browser/static-content-pages
 
### A File Browser Page - Subdirectory Management and Navigation
/admin/content/static-content-browser/static-content-nodes/278025
For listing and managing the files and sub directories in the file space.
Clicking on sub directories switches the browser to that sub directory.
Clicking on a text file loads that file into a WYSIWYG editor displayed in a new browser tab. 


#### Directory Navigation Links

* A Left Up and Right Arrow Icon to go to the next or previous sibling directories or parent directories.

* A Path to the directory being shown.


#### A Drop zone for uploading files to the directory being shown.


#### Three Links for Directory actions

* A folder Icon named New Directory for creating new sub directories in the directory being shown.

* A button titled View index.html for viewing the index.html file in the directory being shown in a new browser tab.

* A file Icon named New Directory for creating new text files in the directory being shown.


#### A table listing the Files or Sub Directories in the directory being shown with these columns.

* Type - A Folder icon is shown for Sub Directories
* Name - File or Subdirectory name and link 
  * Links to to a File Editor for Files. 
  * Links to another browser page for Sub Directories.
* Size - For Files the size of the file is shown. For Sub Directories a hyphen is shown.
  * For Files the size of the file is shown.
  * For Sub Directories a hyphen is shown.

* Modification Date - For Files or Sub Directories the modification date is shown.
* Actions - Three dots foa a popup actions menu.
  * For Files
    * Download
    * Move
  * For Sub Directories
    * Download Zip
    * Rename
    * Delete
  *


### A WYSIWYG Editor Page
/admin/content/static-content-browser/edit/static-content-nodes?file_path=278025/index.html
For editing HTML and text files.

Clicking on a File icon will open an editor page to edit the file selected.

An Example of the url for a file at /static-content-nodes/278025/index.html
/admin/content/static-content-browser/edit/static-content-nodes?file_path=278025/index.html

* The path to the File being edited is provided.

* A WYSIWYG Editor is provided to edit the file.

* A Text Format popup is provided to select Basic, Restricted or Full HTML.

* Save File and Save & Close save the changes buttons Save or Close the Editor.


## Its mostly implemented we just need to fix a few issues.





