<?php

namespace Drupal\static_content_browser\Service;

use Drupal\Core\Site\Settings;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\Access\CsrfTokenGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Helper service for Static Content Browser CSRF token.
 */
class StaticContentBrowserTokenService {
  /**
   * @var \Drupal\Core\Access\CsrfTokenGenerator
   */
  protected $csrfToken;

  /**
   * @var \Drupal\Core\Session\AccountProxyInterface
   */
  protected $currentUser;

  public function __construct(CsrfTokenGenerator $csrf_token, AccountProxyInterface $current_user) {
    $this->csrfToken = $csrf_token;
    $this->currentUser = $current_user;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('csrf_token'),
      $container->get('current_user')
    );
  }

  /**
   * Get a CSRF token for the static content browser AJAX endpoint.
   */
  public function getToken() {
    // Use a fixed string for the operation, or something unique per user/session if needed.
    return $this->csrfToken->get('static_content_browser_ajax');
  }
}
