<?php

namespace Drupal\static_facet_values\Facets;

use Drupal\facets\FacetInterface;
use Drupal\facets\Result\Result;
use Drupal\static_facet_values\StaticFacetValuesServiceInterface;

/**
 * Base class for static facet value service.
 */
abstract class StaticFacetValues implements StaticFacetValuesServiceInterface {

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getResults(FacetInterface $facet, array $results): array {
    return [];
  }

  /**
   * Creates facet results from string values.
   *
   * @param array<string, string> $values
   *   List of values.
   * @param \Drupal\facets\FacetInterface $facet
   *   The facet to create the results for.
   *
   * @return \Drupal\facets\Result\ResultInterface[]
   *   List of facet results.
   */
  protected function translateValuesIntoFacetResults(array $values, FacetInterface $facet): array {
    /** @var \Drupal\facets\Result\ResultInterface[] $results */
    $results = [];
    /** @var array $items_active */
    $items_active = $facet->getActiveItems();

    // Create results from value list.
    foreach ($values as $value => $display_value) {
      $result = new Result(
        facet: $facet,
        raw_value: $value,
        display_value: $display_value,
        count: 1,
      );

      if (in_array($value, $items_active, TRUE)) {
        $result->setActiveState(TRUE);
      }

      $results[$value] = $result;
    }

    return $results;
  }

}
