<?php

namespace Drupal\static_facet_values;

use Drupal\Component\DependencyInjection\ReverseContainer;

/**
 * Defines a service collector for static facet value services.
 */
class StaticFacetValuesCollection implements StaticFacetValuesCollectionInterface {

  /**
   * Constructs a new StaticFacetValuesCollector object.
   *
   * @param \Drupal\static_facet_values\StaticFacetValuesServiceInterface[] $services
   *   List of services tagged with 'static_facet_values'.
   * @param \Drupal\Component\DependencyInjection\ReverseContainer $reverseContainer
   *   Instance of ReverseContainer to lookup service IDs.
   */
  public function __construct(
    protected iterable $services,
    protected ReverseContainer $reverseContainer,
  ) {
    // Nothing to do here.
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function listServices(): array {
    $definitions = [];
    foreach ($this->services as $service) {
      $service_id = $this->reverseContainer->getId($service);
      if (is_null($service_id)) {
        continue;
      }

      $definitions[$service_id] = [
        'name' => (new \ReflectionClass($service::class))->getShortName(),
        'service' => $service,
      ];
    }
    return $definitions;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function listServicesAsOptions(): array {
    $services = $this->listServices();
    /** @var string[] $option_keys */
    $option_keys = array_keys($services);
    /** @var string[] $option_values */
    $option_values = array_column($services, 'name');

    return array_combine($option_keys, $option_values);
  }

}
