<?php

namespace Drupal\static_facet_values;

/**
 * Interface for StaticFacetValues collection.
 */
interface StaticFacetValuesCollectionInterface {

  /**
   * Get a list of all registered static facet value services.
   *
   * @return array<string, array{'name': string, 'service': \Drupal\static_facet_values\StaticFacetValuesServiceInterface}>
   *   List of static facet values services.
   */
  public function listServices(): array;

  /**
   * Get a list of all registered static facet value services as options.
   *
   * @return array<string, string>
   *   List of static facet values services as options for lists.
   */
  public function listServicesAsOptions(): array;

}
