<?php

namespace Drupal\static_facet_values;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderInterface;

/**
 * Custom ServiceProvider class to register tags for autoconfigure.
 */
class StaticFacetValuesServiceProvider implements ServiceProviderInterface {

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function register(ContainerBuilder $container): void {
    $container
      ->registerForAutoconfiguration(StaticFacetValuesServiceInterface::class)
      ->addTag('static_facet_values');
  }

}
