<?php

namespace Drupal\sfv_processor_collection\Facets;

use Drupal\facets\FacetInterface;
use Drupal\facets\Result\Result;
use Drupal\static_facet_values\StaticFacetValuesServiceInterface;

/**
 * Static facet value service for a list of week days.
 */
class StaticDays implements StaticFacetValuesServiceInterface {

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getResults(FacetInterface $facet, array $results): array {
    $count = count($results);
    if ($count === 0) {
      return [];
    }
    // Limit $count to 7.
    $count = min($count, 7);

    $results = [];
    $static_days = [
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
      'Sunday',
    ];

    // Create a static list of week days based on the number of given results.
    $items = range(0, $count - 1);
    foreach ($items as $value) {
      $display_value = $static_days[$value];

      $result = new Result(
        facet: $facet,
        raw_value: $value,
        display_value: $display_value,
        count: 1,
      );

      $results[$value] = $result;
    }

    return $results;
  }

}
