# Static Facet Values

The "Static Facet Values" enables you to rewrite facet values provided by the
[Facets](https://www.drupal.org/project/facets) module with static values.



## Requirements

This module requires the following modules:

- [Facets](https://www.drupal.org/project/facets)


## Installation

Install as usual, see the documentation page about
[installing drupal modules](https://www.drupal.org/docs/extending-drupal/installing-modules) for further information.


## Custom implementation

To use this module you will need to create a custom service class implementing
`\Drupal\static_facet_values\StaticFacetValuesServiceInterface`.

This service will be recognized automatically when using `autoconfigure` in your
_services.yml_:

```yaml
  my_module.facets.static_value.example:
    class: Drupal\my_module\Facets\Example
    autoconfigure: true
    autowire: true
    Drupal\my_module\Facets\Example: '@my_module.facets.static_value.example'
```

You may also set this as default in your _services.yml_:

```yaml
services:
  _defaults:
    autoconfigure: true
```

Alternatively you can manually add the tag "static_facet_values" to your
services:

```yaml
  my_module.facets.static_value.example:
    class: Drupal\my_module\Facets\Example
    autowire: true
    Drupal\my_module\Facets\Example: '@my_module.facets.static_value.example'
    tags:
      { name: 'static_facet_values' }
```

The custom service then is responsible to create the results to display in the
facet widget.

## Facet configuration

To use the custom services you will need to configure the facet to use the
"Static facet values" processor. After enabling the processor you are able to
select one of the implemented services providing custom facet results.

## Contact

- Stefan Borchert - [stborchert](https://www.drupal.org/u/stborchert)

**This project has been sponsored by:**

- undpaul
  Drupal experts providing professional Drupal development services.
  Visit [undpaul](https://www.undpaul.de) for more information.