<?php

namespace Drupal\static_facet_values;

use Drupal\facets\FacetInterface;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;

/**
 * Interface for static facet value services.
 *
 * All services implementing this interface theoretically get the tag
 * "static_facet_values" automatically so the services can be collected by
 * \Drupal\static_facet_values\StaticFacetValuesCollection. Unfortunately this
 * does not work in Drupal 10 so services needs to define the tag manually in
 * their respective <i>services.yml</i>.
 */
#[AutoconfigureTag('static_facet_values')]
interface StaticFacetValuesServiceInterface {

  /**
   * Get static result list for facet.
   *
   * @param \Drupal\facets\FacetInterface $facet
   *   The facet being changed.
   * @param \Drupal\facets\Result\ResultInterface[] $results
   *   The results being changed.
   *
   * @return \Drupal\facets\Result\ResultInterface[]
   *   The result list.
   */
  public function getResults(FacetInterface $facet, array $results): array;

}
