<?php

namespace Drupal\sfv_processor_collection\Facets;

use Drupal\facets\FacetInterface;
use Drupal\facets\Result\Result;
use Drupal\static_facet_values\StaticFacetValuesServiceInterface;

/**
 * Static facet value service for a list of numbers.
 */
class StaticNumbers implements StaticFacetValuesServiceInterface {

  const FORMATTER_LOCALE = 'en_US';

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getResults(FacetInterface $facet, array $results): array {
    $count = count($results);
    if ($count === 0) {
      return [];
    }

    $results = [];

    // Create a static list of numbers based on the number of given results.
    $items = range(1, $count);
    $format = numfmt_create(self::FORMATTER_LOCALE, \NumberFormatter::SPELLOUT);
    if (is_null($format)) {
      return [];
    }

    foreach ($items as $value) {
      $display_value = numfmt_format($format, $value);

      $result = new Result(
        facet: $facet,
        raw_value: $value,
        display_value: $display_value,
        count: 1,
      );

      $results[$value] = $result;
    }

    return $results;
  }

}
