<?php

namespace Drupal\Tests\static_facet_values\Functional;

use Drupal\static_facet_values\Plugin\facets\processor\StaticValuesProcessor;
use Drupal\Tests\facets\Functional\FacetsTestBase;
use Drupal\Tests\static_facet_values\Unit\StaticFacetValuesTestInterface;

/**
 * Tests the processor functionality.
 *
 * @group static_facet_values
 */
class ProcessorIntegrationTest extends FacetsTestBase {

  /**
   * The url of the edit form.
   *
   * @var string
   */
  protected $editForm;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'static_facet_values',
    'facets',
    'search_api',
    'options',
    'sfv_processor_collection',
  ];

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->drupalLogin($this->adminUser);

    // Set up example content types and insert 10 new content items.
    $this->setUpExampleStructure();
    $this->insertExampleContent();
    $this->assertEquals($this->indexItems($this->indexId), 5, '5 items were indexed.');
    $this->insertExampleContent();
    $this->assertEquals($this->indexItems($this->indexId), 5, '5 items were indexed.');
  }

  /**
   * Tests for the processors behavior in the backend.
   */
  public function testProcessorAdmin(): void {
    $facet_name = "Guanaco";
    $facet_id = "guanaco";

    $this->createFacet($facet_name, $facet_id);

    // Go to the processors form and check that the sfv_static_values processor
    // is not checked.
    $this->drupalGet('admin/config/search/facets/' . $facet_id . '/edit');
    $this->assertSession()->checkboxNotChecked('edit-facet-settings-sfv-static-values-status');

    // Enable the processor.
    $form = ['facet_settings[sfv_static_values][status]' => TRUE];
    $this->submitForm($form, 'Save');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->checkboxChecked('edit-facet-settings-sfv-static-values-status');

    $option_none = $this->assertSession()->optionExists('edit-facet-settings-sfv-static-values-settings-static-value-service', StaticValuesProcessor::OPTION_NONE);
    $this->assertTrue($option_none->hasAttribute('selected'));
    $this->assertSession()->optionExists('edit-facet-settings-sfv-static-values-settings-static-value-service', StaticFacetValuesTestInterface::VALUES_SERVICE_NUMBERS);
    $this->assertSession()->optionExists('edit-facet-settings-sfv-static-values-settings-static-value-service', StaticFacetValuesTestInterface::VALUES_SERVICE_DAYS);
  }

}
