<?php

namespace Drupal\Tests\static_facet_values\Unit;

use Drupal\Component\DependencyInjection\Container;
use Drupal\Component\DependencyInjection\ReverseContainer;
use Drupal\Tests\UnitTestCase;
use Drupal\sfv_processor_collection\Facets\StaticDays;
use Drupal\sfv_processor_collection\Facets\StaticNumbers;
use Drupal\static_facet_values\StaticFacetValuesCollection;

/**
 * Tests the static_facet_values service collection.
 *
 * @coversDefaultClass \Drupal\static_facet_values\StaticFacetValuesCollection
 * @group static_facet_values
 */
class StaticFacetValuesCollectionTest extends UnitTestCase implements StaticFacetValuesTestInterface {

  /**
   * The collection service under test.
   *
   * @var \Drupal\static_facet_values\StaticFacetValuesCollection
   */
  protected $collection;

  /**
   * A mock of the StaticNumbers service.
   *
   * @var \PHPUnit\Framework\MockObject\MockObject|\Drupal\sfv_processor_collection\Facets\StaticNumbers
   */
  protected $numbersProcessor;

  /**
   * A mock of the StaticDays service.
   *
   * @var \PHPUnit\Framework\MockObject\MockObject|\Drupal\sfv_processor_collection\Facets\StaticDays
   */
  protected $daysProcessor;

  /**
   * An instance of the ReverseContainer.
   *
   * @var \Drupal\Component\DependencyInjection\ReverseContainer
   */
  protected $reverseContainer;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create mocks for the processor services.
    $this->numbersProcessor = $this->createMock(StaticNumbers::class);
    $this->daysProcessor = $this->createMock(StaticDays::class);

    $numbers_service_id = self::VALUES_SERVICE_NUMBERS;
    $days_service_id = self::VALUES_SERVICE_DAYS;

    // Create a container object.
    $container = new Container();

    // Place mocked services into the container.
    $container->set($numbers_service_id, $this->numbersProcessor);
    $container->set($days_service_id, $this->daysProcessor);

    // Instantiate a ReverseContainer with the populated container.
    $reverseContainer = new ReverseContainer($container);

    // Instantiate the collection service.
    $this->collection = new StaticFacetValuesCollection(
      [$this->numbersProcessor, $this->daysProcessor],
      $reverseContainer
    );
  }

  /**
   * @covers ::listServices
   */
  public function testListServices(): void {
    $expected = [
      self::VALUES_SERVICE_NUMBERS => [
        'name' => 'StaticNumbers',
        'service' => $this->numbersProcessor,
      ],
      self::VALUES_SERVICE_DAYS => [
        'name' => 'StaticDays',
        'service' => $this->daysProcessor,
      ],
    ];

    $services_returned = $this->collection->listServices();
    // Rewrite the class names since the names of the mocked services classes
    // start with "Mock_" and end with a random string (e.g.
    // "Mock_StaticNumbersProcessor_5c3c1a86").
    $services_transformed = array_map(function ($item) {
      $item['name'] = explode('_', $item['name'])[1];
      return $item;
    }, $services_returned);

    $this->assertEquals($expected, $services_transformed);
  }

  /**
   * @covers ::listServicesAsOptions
   */
  public function testListServicesAsOptions(): void {
    $expected = [
      self::VALUES_SERVICE_NUMBERS => 'StaticNumbers',
      self::VALUES_SERVICE_DAYS => 'StaticDays',
    ];

    $services = $this->collection->listServicesAsOptions();
    // Rewrite the class names since the names of the mocked services classes
    // start with "Mock_" and end with a random string (e.g.
    // "Mock_StaticNumbersProcessor_5c3c1a86").
    $services_transformed = array_map(fn($value) => explode('_', $value)[1], $services);

    $this->assertEquals($expected, $services_transformed);
  }

}
