<?php

namespace Drupal\static_page\EventSubscriber;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Routing\CurrentRouteMatch;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Static Page subscriber for controller requests.
 */
class StaticPageSubscriber implements EventSubscriberInterface {

  /**
   * The current route match.
   */
  protected CurrentRouteMatch $routeMatch;

  /**
   * The entity type manager.
   */
  protected EntityTypeManagerInterface $entityTypeManager;

  /**
   * The config factory.
   */
  protected ConfigFactoryInterface $configFactory;

  /**
   * Creates a new StaticPageSubscriber instance.
   */
  public function __construct(CurrentRouteMatch $route_match, EntityTypeManagerInterface $entity_type_manager, ConfigFactoryInterface $config_factory) {
    $this->routeMatch = $route_match;
    $this->entityTypeManager = $entity_type_manager;
    $this->configFactory = $config_factory;
  }

  /**
   * Performs check on the beginning of a request.
   */
  public function onRequest(RequestEvent $event) {

    $node = NULL;
    $route_name = $this->routeMatch->getRouteName();

    if ($route_name == 'entity.node.canonical') {
      $node = $this->routeMatch->getParameter('node');
    }
    elseif ($route_name == 'entity.node.revision') {
      $vid = (int) $this->routeMatch->getRawParameter('node_revision');
      if ($vid) {
        $node = $this->entityTypeManager->getStorage('node')->loadRevision($vid);
      }
    }
    if (!empty($node)) {
      $type = $node->getType();
      $config = $this->configFactory->get('static_page.fields');
      $static_fields = $config->get('fields');
      if (!empty($static_fields[$type])) {
        $static_page = $node->get($static_fields[$type])->value;
        $response = new Response($static_page);
        $event->setResponse($response);
      }
    }

  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[KernelEvents::REQUEST][] = ['onRequest'];
    // $events[KernelEvents::RESPONSE][] = array('onResponse');
    return $events;
  }

}
