<?php

declare(strict_types=1);

namespace Drupal\Tests\static_page\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests that all config provided by this module passes validation.
 *
 * @group static_page
 */
class StaticPageConfigTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['static_page', 'node', 'user'];

  /**
   * Tests that the module's config installs properly.
   */
  public function testConfig() {
    $this->installEntitySchema('user');
    $this->installEntitySchema('node');
    $this->installEntitySchema('node_type');
    $this->installConfig(['static_page']);
    $static_page_config = $this->config('static_page.fields');
    $this->assertEquals([], $static_page_config->get('fields'));
  }

}
