# StaticJSONv1

A Drupal module to generate **static JSON files** from selected entities and expose them through custom routes.  
Un módulo de Drupal para generar **archivos JSON estáticos** desde entidades seleccionadas y exponerlos mediante rutas personalizadas.

---

## 📦 Overview / Descripción

**StaticJSONv1** allows you to export Drupal entities as static JSON files.  
It provides:

- A configuration page to select which entities and bundles are exported.
- Routes to fetch JSON for a single entity.
- A route to compress all JSON files into a ZIP.
- Drush commands to generate and compress JSON files.

**StaticJSONv1** permite exportar entidades de Drupal como archivos JSON estáticos.  
Incluye:

- Una página de configuración para elegir entidades y bundles.
- Rutas para obtener el JSON de una entidad.
- Una ruta para comprimir todos los JSON en un ZIP.
- Comandos Drush para generar y comprimir los archivos.

---

## ⚙️ Configuration / Configuración

Go to / Ir a:

```
/admin/config/system/settings
```

There you can select which entity types and bundles should be generated as JSON.  
Ahí puedes seleccionar qué tipos de entidad y bundles se exportarán a JSON.

---

## 🌐 Routes / Rutas

| Route / Ruta | Description / Descripción |
|--------------|---------------------------|
| `/staticjson/{bundle}/{id}` | Get JSON of a specific entity / Obtiene el JSON de una entidad |
| `/staticjson/compress` | Compress all JSON files into a ZIP / Comprime todos los JSON en un ZIP |

### Example / Ejemplo

```
/staticjson/article/123
```

Returns the JSON of the article with ID 123.  
Devuelve el JSON del artículo con ID 123.

---

## 🛠 Drush Commands / Comandos Drush

### Generate JSON files / Generar archivos JSON

```bash
drush staticjson:generate
```

Generates all static JSON files for the entities selected in configuration.  
Genera todos los JSON de las entidades configuradas.

---

### Compress JSON files / Comprimir archivos JSON

```bash
drush staticjson:compress
```

Creates a ZIP file with all generated JSON files.  
Crea un archivo ZIP con todos los JSON generados.

---

## 🧠 How it works / Cómo funciona

1. You select entity types and bundles in the settings page.  
2. Run the Drush command to generate JSON files.  
3. The module stores JSON files in a public directory.  
4. Routes serve the JSON directly from those files.

---

1. Seleccionas los tipos de entidad y bundles en la configuración.  
2. Ejecutas el comando Drush para generar los JSON.  
3. El módulo guarda los archivos en un directorio público.  
4. Las rutas entregan esos JSON directamente.

---

## ⚠️ Notes / Notas

- Make sure Drupal has write permissions to the public files directory.
- This module is ideal for decoupled or static frontends.

---

- Asegúrate de que Drupal tenga permisos de escritura en `public://`.
- Ideal para frontends desacoplados o proyectos estáticos.

---

## 📄 License / Licencia

This project is licensed under the GPL-2.0-or-later.  
Este proyecto está bajo licencia GPL-2.0-or-later.

---

## 👨‍💻 Author / Autor

César Iván Garzón Lamprea  
Drupal Module: https://www.drupal.org/project/staticjsonv1