<?php

namespace Drupal\staticjson\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class JsonViewController {

  public function build($bundle, $id) {
    $service = \Drupal::service('staticjson.storage_reader');

    $data = $service->loadJson($bundle, $id);

    if (!$data) {
      return new JsonResponse(['error' => 'No existe'], 404);
    }

    return new JsonResponse($data);
  }

  public function compress($id) {
    $service = \Drupal::service('staticjson.storage_reader');
    return $service->loadLocalCopress($id);
  }
}
