<?php

namespace Drupal\staticjson\Drush\Commands;

use Consolidation\OutputFormatters\StructuredData\RowsOfFields;
use Drupal\Core\Utility\Token;
use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Batch\BatchBuilder;
use Drupal\staticjson\Services\StaticJsonFormHandler;
  use Drupal\Core\Entity\EntityInterface;
/**
 * A Drush commandfile.
 */
final class StaticjsonCommands extends DrushCommands {

  /**
   * Constructs a StaticjsonCommands object.
   */
  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
    protected StaticJsonFormHandler $staticJsonService,
  ) {
    parent::__construct();
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('entity_type.manager'),
      $container->get('staticjson.form_handler'),
    );
  }

  /**
   * Command Generate statics.
   */
  #[CLI\Command(name: 'staticjson:generate')]
  #[CLI\Usage(name: 'staticjson:generate', description: 'Genera JSON estático')]

   public function commandName() {
     $batch_builder = (new BatchBuilder())
      ->setTitle(t('Generando JSON estático'))
      ->setFinishCallback([self::class, 'batchFinished']);

      
    // -------------------------
    // NODOS
    // -------------------------
    $node_types = $this->entityTypeManager
      ->getStorage('node_type')
      ->loadMultiple();

    foreach ($node_types as $type) {
      $nids = $this->entityTypeManager
        ->getStorage('node')
        ->getQuery()
        ->accessCheck(FALSE)
        ->condition('type', $type->id())
        ->execute();

      if ($nids) {
        $batch_builder->addOperation(
          [self::class, 'processEntities'],
          ['node', $nids]
        );
      }
    }

    // -------------------------
    // TAXONOMÍAS
    // -------------------------
    $vocabularies = $this->entityTypeManager
      ->getStorage('taxonomy_vocabulary')
      ->loadMultiple();

    foreach ($vocabularies as $vocabulary) {
      $tids = $this->entityTypeManager
        ->getStorage('taxonomy_term')
        ->getQuery()
        ->accessCheck(FALSE)
        ->condition('vid', $vocabulary->id())
        ->execute();

      if ($tids) {
        $batch_builder->addOperation(
          [self::class, 'processEntities'],
          ['taxonomy_term', $tids]
        );
      }
    }

    batch_set($batch_builder->toArray());
    drush_backend_batch_process();
  }

  public static function batchFinished(bool $success, array $results, array $operations): void {
    if ($success) {
      \Drupal::messenger()->addStatus(t('JSON estático generado correctamente.'));
    }
    else {
      \Drupal::messenger()->addError(t('Ocurrió un error durante la generación.'));
    }
  }

  public static function processEntities(string $entity_type, array $ids, array &$context): void {
    if (!isset($context['results']['processed'])) {
      $context['results']['processed'] = 0;
    }

    $entity_type_manager = \Drupal::entityTypeManager();
    $handler = \Drupal::service('staticjson.form_handler');

    $storage = $entity_type_manager->getStorage($entity_type);

    foreach ($ids as $id) {
      /** @var \Drupal\Core\Entity\EntityInterface|null $entity */
      $entity = $storage->load($id);

      if (!$entity instanceof EntityInterface) {
        continue;
      }

      // 🔁 Equivalente a lo que sacabas del form_state
      $bundle = $entity->bundle();
      $is_new = FALSE; // En batch siempre es entidad existente
      $form_id = 'drush_staticjson_batch';

      // 🔥 Tu lógica original
      $handler->handleEntity(
        $entity,
        [
          'entity_type' => $entity_type,
          'bundle' => $bundle,
          'is_new' => $is_new,
          'form_id' => $form_id,
        ]
      );

      $context['results']['processed']++;
    }

    $context['message'] = t(
      'Procesando @type (@count elementos)',
      [
        '@type' => $entity_type,
        '@count' => count($ids),
      ]
    );
  }


    /**
   * Command Generate statics.
   */
  #[CLI\Command(name: 'staticjson:compress')]
  #[CLI\Usage(name: 'staticjson:compress ', description: 'Genera Compress json')]

  public function commandCompress() {
    $services = \Drupal::service('staticjson.form_handler');
    $services->generateCompress('Static_Json');

  }

}
