<?php

namespace Drupal\staticjson\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Staticjson compressbatch for this site.
 */
class CompressbatchForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'staticjson_compressbatch';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['staticjson.compressbatch'];
  }

  /**
   * {@inheritdoc}
   */
public function buildForm(array $form, FormStateInterface $form_state) {

  $form['name'] = [
    '#type' => 'textfield',
    '#title' => $this->t('Name of file'),
    '#default_value' => "Static_Json" ?? [],
  ];

  return parent::buildForm($form, $form_state);
}


  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    if (strlen($form_state->getValue('name')) < 3) {
     $form_state->setErrorByName('name', $this->t('The Name of file is required.'));
    }
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $services = \Drupal::service('staticjson.form_handler');
    $services->generateCompress($form_state->getValue('name'));
    $this->messenger()->addStatus($this->t('Thank you, @name. Your form has been submitted successfully.', ['@name' => $name]));
  }


}
