<?php

namespace Drupal\staticjson\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Staticjson settings for this site.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'staticjson_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['staticjson.settings'];
  }

  /**
   * {@inheritdoc}
   */
public function buildForm(array $form, FormStateInterface $form_state) {

  /* ========================
   * TIPOS DE CONTENIDO
   * ======================== */
  $content_types = \Drupal::entityTypeManager()
    ->getStorage('node_type')
    ->loadMultiple();

  $content_options = [];
  foreach ($content_types as $id => $type) {
    $content_options[$id] = $type->label();
  }

  $form['content_types'] = [
    '#type' => 'checkboxes',
    '#title' => $this->t('Tipos de contenido'),
    '#options' => $content_options,
    '#default_value' => $this->config('staticjson.settings')->get('content_types') ?? [],
  ];


  /* ========================
   * MENÚS
   * ======================== */
  $menus = \Drupal::entityTypeManager()
    ->getStorage('menu')
    ->loadMultiple();

  $menu_options = [];
  foreach ($menus as $id => $menu) {
    $menu_options[$id] = $menu->label();
  }

  $form['menus'] = [
    '#type' => 'checkboxes',
    '#title' => $this->t('Menús'),
    '#options' => $menu_options,
    '#default_value' => $this->config('staticjson.settings')->get('menus') ?? [],
  ];

  $vocabularies = \Drupal::entityTypeManager()
    ->getStorage('taxonomy_vocabulary')
    ->loadMultiple();

  $vocab_options = [];
  foreach ($vocabularies as $id => $voc) {
    $vocab_options[$id] = $voc->label();
  }

  $form['vocabularies'] = [
    '#type' => 'checkboxes',
    '#title' => $this->t('Taxonomías (Vocabularios)'),
    '#options' => $vocab_options,
    '#default_value' => $this->config('staticjson.settings')->get('vocabularies') ?? [],
  ];

  return parent::buildForm($form, $form_state);
}


  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {

    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $form_state->getValue('example');
    $this->config('staticjson.settings')
      ->set('content_types', array_filter($form_state->getValue('content_types')))
      ->set('menus', array_filter($form_state->getValue('menus')))
      ->set('vocabularies', array_filter($form_state->getValue('vocabularies')))
      ->save();

    parent::submitForm($form, $form_state);
  }


}
