<?php

namespace Drupal\stenographer;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface for defining plugins for making data available for logging.
 */
interface DataAdapterInterface extends PluginInspectionInterface {

  /**
   * Is this property available from this data adapter.
   *
   * @param string $name
   *   Name of the property to check if it is available for this adapter.
   * @param array<string,mixed> $data
   *   Data provided for the recorder to extract and provide values from.
   *
   * @return bool
   *   TRUE if the property is available and FALSE otherwise.
   */
  public function hasProperty(string $name, array $data): bool;

  /**
   * Fetches a value based on the requested property name.
   *
   * @param string $name
   *   Name of the property to fetch from the object.
   * @param array<string,mixed> $data
   *   Data provided for the recorder to extract and provide values from.
   *
   * @return mixed
   *   Get the main property value of a field.
   */
  public function get(string $name, array $data): mixed;

  /**
   * Apply the data properties requested to the data array.
   *
   * @param array $data
   *   Reference to the data array to apply the data properties to.
   * @param array $properties
   *   The data property mapping of data properties to apply to the data set.
   */
  public function applyData(array &$data, array $src, array $properties): void;

}
