<?php

namespace Drupal\stenographer\Trigger;

/**
 * Trigger definitions for hooks.
 */
class HookTriggers implements TriggerBuilderInterface {

  /**
   * {@inheritdoc}
   */
  public function getTriggerType(): string {
    return 'hook';
  }

  /**
   * {@inheritdoc}
   */
  public function buildTriggers(array $recorders): array {
    $type = $this->getTriggerType();

    $triggers = [];
    foreach ($recorders as $recorder) {
      $rid = $recorder->id();

      foreach ($recorder->getTriggers($type) as $key => $label) {
        $triggers[$key][$rid] = $rid;
      }
    }

    return $triggers;
  }

}
