<?php

namespace Drupal\stenographer;

/**
 * Interface for defining plugins for making data available for logging.
 */
interface TypedDataAdapterInterface extends DataAdapterInterface {

  /**
   * Get the available properties of the underlying data objects of the adapter.
   *
   * @param array<string,mixed> $data
   *   Data provided for the recorder to extract and provide values from.
   *
   * @return \Drupal\Core\TypedData\DataDefinitionInterface[]
   *   Get an array of data definitions available for the this data adapter.
   *   This definition can be used to determine what type of data is being
   *   stored along with any constraints (validation).
   */
  public function propertyDefinitions(array $data): array;

}
