<?php

namespace Drupal\stenographer;

/**
 * Interface for storage implementations that buffer data writes.
 *
 * For efficiency and sometime rate limits, some storage writers need to
 * buffer individual writes to their storage backends. The storage writers
 * need to manage this internally and allow the system to flush the output
 * buffers.
 */
interface BufferedStoreInterface extends StoreInterface {

  /**
   * Flush any buffers and pending writes.
   */
  public function flush();

}
