<?php

namespace Drupal\stenographer\Capture;

use Drupal\toolshed\Strategy\StrategyInterface;

/**
 * Base event capture strategy interface.
 */
interface CaptureInterface extends StrategyInterface {

  /**
   * Is this event on that should always be passed to the storage handler.
   *
   * Some data is not tracked, and cannot be used to determine if an event
   * should be captured or not. If this event is configured to be pass-thru then
   * the event is sent to the storage, with the strategy ID to control how
   * the storage should attempt to capture.
   *
   * @return bool
   *   Is this event a pass-thru type (alway send, resolve on storage side).
   */
  public function isPassThru(): bool;

  /**
   * Should this event be captured (sent to storage)?
   *
   * @param array $config
   *   The logger configuration for this capture method if any.
   *
   * @return bool
   *   Should even be captured?
   */
  public function shouldCapture(array $config = []): bool;

  /**
   * Format the strategy label to be applied to the log event capture setting.
   *
   * @return string|null
   *   The capture data field string to include when sending of the log event.
   */
  public function formatStrategy(array $config = []): ?string;

}
