<?php

namespace Drupal\stenographer;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\stenographer\Attribute\StenographerCapture;
use Drupal\stenographer\Capture\CaptureDefinition;
use Drupal\stenographer\Capture\CaptureInterface;
use Drupal\stenographer\Capture\EventCapture;
use Drupal\toolshed\Strategy\StrategyDefinitionInterface;
use Drupal\toolshed\Strategy\StrategyManager;

/**
 * The capture strategy manager for logging events.
 */
class CaptureStrategyManager extends StrategyManager implements CaptureStrategyManagerInterface {

  /**
   * The interface implmented by all capture strategies.
   *
   * @var class-string<\Drupal\stenographer\Capture\CaptureInterface>
   */
  protected string $strategyInterface = CaptureInterface::class;

  /**
   * Create a new instance of the CaptureStrategyManager class.
   *
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $moduleHandler
   *   The module handler service.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache
   *   The cache storage backend for caching definitions.
   */
  public function __construct(ModuleHandlerInterface $moduleHandler, CacheBackendInterface $cache) {
    $discovery = [
      'name' => 'stenographer_capture',
      'attribute' => StenographerCapture::class,
      'subdir' => 'Capture',
    ];

    parent::__construct($discovery, $moduleHandler, $cache, ['stenographer:capture']);
  }

  /**
   * {@inheritdoc}
   */
  protected function defaultStrategyClass(array $definition): string {
    return EventCapture::class;
  }

  /**
   * {@inheritdoc}
   */
  protected function processDefinition(string $id, array $definition): StrategyDefinitionInterface {
    return new CaptureDefinition($id, $definition);
  }

}
