<?php

namespace Drupal\stenographer\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Entity\EntityTypeRepositoryInterface;
use Drupal\Core\Plugin\Context\EntityContextDefinition;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides an entity data adapter for all content entity types.
 */
class EntityAdapterDeriver extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * Constructs new EntityDataAdapterDeriver.
   *
   * @param string $basePluginId
   *   The original plugin ID for which the derived definitions come from.
   * @param \Drupal\Core\Entity\EntityTypeRepositoryInterface $entityTypeRepository
   *   The entity type repository.
   */
  public function __construct(
    protected string $basePluginId,
    protected EntityTypeRepositoryInterface $entityTypeRepository,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $base_plugin_id,
      $container->get('entity_type.repository')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($basePluginDef): array {
    $typeLabels = $this->entityTypeRepository->getEntityTypeLabels(TRUE);

    if (!is_array($basePluginDef)) {
      $basePluginDef = [];
    }

    $this->derivatives = [];
    foreach ($typeLabels['Content'] as $typeId => $typeLabel) {
      $contextDef = EntityContextDefinition::fromEntityTypeId($typeId);
      $contextDef->setLabel($typeLabel);
      $contextDef->setRequired(FALSE);

      $this->derivatives[$typeId] = [
        'context_definitions' => [
          $typeId => $contextDef,
        ],
      ] + $basePluginDef;
    }

    return $this->derivatives;
  }

}
