<?php

namespace Drupal\stenographer;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Drupal\stenographer\Hook\HookHandler;

/**
 * Module service provider to adjust hook implementation definitions.
 */
class StenographerServiceProvider extends ServiceProviderBase {

  /**
   * Add hook definitions to the "hook_implementations_map" container parameter.
   *
   * @param \Drupal\Core\DependencyInjection\ContainerBuilder $container
   *   The dependency injection container builder.
   */
  public function alter(ContainerBuilder $container): void {
    $loaded = FALSE;
    $hooks = function_exists('apcu_fetch') ? \apcu_fetch('stenographer:hooks', $loaded) : [];

    if (!$loaded) {
      $hooks = [];
      $dirs = [];

      // Find Odinsi loggers which trigger on hooks, and add them to the list
      // of hooks that need to be called by a Odinsi logger.
      foreach ($container->getParameter('container.modules') as $module => $info) {
        if ('module' === $info['type'] && !empty($info['pathname'])) {
          $dirs[$module] = \dirname($info['pathname']);
        }
      }

      $discovery = RecorderManager::createDiscovery($dirs);
      foreach ($discovery->findAll() as $fileDef) {
        foreach ($fileDef as $loggerDef) {
          $keys = \array_keys($loggerDef['trigger']['hook'] ?? []);
          $hooks += \array_combine($keys, $keys);
        }
      }

      \apcu_store('stenographer:hooks', \array_unique($hooks));
    }

    // Add our hooks to the implementation map.
    $map = $container->getParameter('hook_implementations_map');
    foreach ($hooks as $hook) {
      $map[$hook][HookHandler::class]['__invoke'] = 'stenographer';
    }
    $container->setParameter('hook_implementations_map', $map);
  }

}
