<?php

namespace Drupal\stenographer\Trigger;

/**
 * Maintains and builds the mapping between triggers and recorders.
 *
 * A trigger handler is responsible for building trigger mappings in a
 * consistent way, so these hooks can be found when defining triggers, and
 * when executing them.
 */
interface TriggerBuilderInterface {

  /**
   * Get the trigger type.
   *
   * @return string
   *   The trigger type identifier.
   */
  public function getTriggerType(): string;

  /**
   * Generate a map of triggers and the recorders that listen for them.
   *
   * @param \Drupal\stenographer\RecorderInterface[] $recorders
   *   List of recorder instances to map to triggers.
   *
   * @return array<string,string[]>
   *   A list of triggers and the IDs of the recorders that listen for them.
   *   The array key is the trigger identifier, and the value is an list of
   *   recorder IDs.
   */
  public function buildTriggers(array $recorders): array;

}
