<?php

namespace Drupal\stenographer\Capture;

use Drupal\Core\Session\AccountInterface;
use Drupal\stenographer\Attribute\StenographerCapture;
use Drupal\toolshed\Strategy\ContainerInjectionStrategyInterface;
use Drupal\toolshed\Strategy\StrategyDefinitionInterface;
use Drupal\toolshed\Strategy\StrategyInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Only capture this event only for anonymous users.
 *
 * @see self::shouldCapture()
 */
#[StenographerCapture(
  id: 'anonymous_user',
  isPassThru: FALSE,
)]
class AnonymousCapture extends EventCapture implements ContainerInjectionStrategyInterface {

  /**
   * Create new instance of the AnonymousCapture strategy.
   *
   * @param string $id
   *   The unique capture strategy identifier.
   * @param \Drupal\stenographer\Capture\CaptureDefinition $definition
   *   The capture strategy definition.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The current user account.
   */
  public function __construct(
    string $id,
    CaptureDefinition $definition,
    protected AccountInterface $account,
  ) {
    parent::__construct($id, $definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, string $id, StrategyDefinitionInterface $definition): StrategyInterface {
    return new static(
      $id,
      $definition,
      $container->get('current_user')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function shouldCapture(array $config = []): bool {
    // Capture the event only if the current user is anonymous.
    return $this->account->isAnonymous();
  }

  /**
   * {@inheritdoc}
   */
  public function formatStrategy(array $config = []): ?string {
    // The data is always captured on the storage API since the authenticated
    // status is being determined on the Drupal side.
    return 'always';
  }

}
