<?php

namespace Drupal\stenographer\Capture;

use Drupal\stenographer\Attribute\StenographerCapture;
use Drupal\toolshed\Strategy\StrategyBase;
use Drupal\toolshed\Strategy\StrategyDefinitionInterface;

/**
 * Base event capture strategy.
 */
#[StenographerCapture(
  id: 'always',
  isPassThru: TRUE,
)]
class EventCapture extends StrategyBase implements CaptureInterface {

  /**
   * Create a new instance of the default event capture strategy.
   *
   * @param string $id
   *   The capture type identifier.
   * @param \Drupal\stenographer\Capture\CaptureDefinition $definition
   *   The event capture definition.
   */
  public function __construct(
    protected string $id,
    protected StrategyDefinitionInterface $definition,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function isPassThru(): bool {
    return $this->definition->isPassThru();
  }

  /**
   * {@inheritdoc}
   */
  public function shouldCapture(array $config = []): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function formatStrategy(array $config = []): ?string {
    return $this->definition->id();
  }

}
