<?php

namespace Drupal\stenographer;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface for defining Stenographer condition plugins.
 */
interface ConditionInterface extends PluginInspectionInterface {

  /**
   * Evaluate the condition against the event data.
   *
   * @param array $data
   *   The event data to test the conditions for.
   *
   * @return bool
   *   TRUE if the data conditions and recorder pass. FALSE otherwise, and if
   *   the logger should be prevented from being sent.
   */
  public function evaluate(array $data): bool;

}
