<?php

namespace Drupal\stenographer;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class to implement a data adapter plugin.
 */
abstract class DataAdapterBase extends PluginBase implements DataAdapterInterface {

  /**
   * {@inheritdoc}
   */
  public function applyData(array &$data, array $src, array $properties): void {
    foreach ($properties as $key => $propertyName) {
      if ($this->hasProperty($propertyName, $src)) {
        $data[$key] = $this->get($propertyName, $src);
      }
    }
  }

}
