<?php

namespace Drupal\stenographer\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\stenographer\Attribute\StenographerCondition;
use Drupal\stenographer\ConditionInterface;

/**
 * Plugin manager for stenographer condition plugins.
 */
class ConditionPluginManager extends DefaultPluginManager {

  /**
   * Creates a new instance of the ConditionPluginManager class.
   *
   * @param \Traversable $namespaces
   *   The namespaces to search for data condition definitions.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cacheBackend
   *   The cache backend to stenographer data condition plugin definitions.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $moduleHandler
   *   The module extension handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cacheBackend, ModuleHandlerInterface $moduleHandler) {
    parent::__construct(
      'Plugin/Stenographer/Condition',
      $namespaces,
      $moduleHandler,
      ConditionInterface::class,
      StenographerCondition::class,
    );

    $this->setCacheBackend($cacheBackend, 'stenographer.condition');
    $this->alterInfo('stenographer_condition');
  }

}
