<?php

namespace Drupal\stenographer\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\stenographer\Attribute\StenographerAdapter;
use Drupal\stenographer\DataAdapterInterface;

/**
 * Plugin manager for stenographer storage plugins.
 */
class DataAdapterPluginManager extends DefaultPluginManager {

  /**
   * Creates a new instance of the DataAdapterPluginManager class.
   *
   * @param \Traversable $namespaces
   *   The namespaces to search for data adapter plugin definitions.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cacheBackend
   *   The cache backend to store plugin definitions.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $moduleHandler
   *   The module extension handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cacheBackend, ModuleHandlerInterface $moduleHandler) {
    parent::__construct(
      'Plugin/Stenographer/Adapter',
      $namespaces,
      $moduleHandler,
      DataAdapterInterface::class,
      StenographerAdapter::class,
    );

    $this->setCacheBackend($cacheBackend, 'stenographer.data_adapter');
    $this->alterInfo('stenographer_data_adapter');
  }

}
