<?php

namespace Drupal\stenographer;

use Drupal\toolshed\Strategy\StrategyInterface;

/**
 * The interface for Stenographer event recorders.
 */
interface RecorderInterface extends StrategyInterface {

  /**
   * Get trigger definitions for this recorder.
   *
   * @param string|null $type
   *   The type of trigger definition to return. Trigger types should be the
   *   key of the triggers array, such as: entity, form, exception, hook...
   *
   * @return array
   *   Trigger definitions which match the requested trigger type. All trigger
   *   definitions if no type was specified.
   */
  public function getTriggers(?string $type = NULL): array;

  /**
   * Commit data to the storage destinations.
   *
   * @param string $type
   *   The recorder trigger type for this event.
   * @param string|null $event
   *   An event string value, to report the type of event which was triggered.
   * @param array<string,mixed> $data
   *   Data to extract record entry properties from.
   */
  public function logEvent(string $type, ?string $event = NULL, array $data = []): void;

  /**
   * The tracking stream is being closed, allow finalization tasks to run.
   */
  public function close(): void;

}
